import React from "react";
import Toast from "react-native-toast-message";
import Welcome from "./Welcome";
import NoInternet from "../../src/components/NoInternet/NoInternet";
import { toastConfig } from "../../src/components/ToastConfig/toastConfig";
import useCheckInternet from "../../hooks/useCheckInternet";
import BackOnline from "../../src/components/NoInternet/BackOnline";
import useGuestUser from "../../hooks/useGuestUser";

const Root = () => {
    const { isOnline, initialInternetCheck } = useCheckInternet();
    useGuestUser(); // !Don't remove this line (It's working like a provider)
    return (
        <>
            <Welcome />
            {!isOnline && <NoInternet />}
            {isOnline && initialInternetCheck && <BackOnline />}
            <Toast config={toastConfig} />
        </>
    );
};

export default Root;
